/*
 * Copyright (c) 2024 EdgeImpulse Inc.
 *
 * Generated by Edge Impulse and licensed under the applicable Edge Impulse
 * Terms of Service. Community and Professional Terms of Service
 * (https://edgeimpulse.com/legal/terms-of-service) or Enterprise Terms of
 * Service (https://edgeimpulse.com/legal/enterprise-terms-of-service),
 * according to your product plan subscription (the “License”).
 *
 * This software, documentation and other associated files (collectively referred
 * to as the “Software”) is a single SDK variation generated by the Edge Impulse
 * platform and requires an active paid Edge Impulse subscription to use this
 * Software for any purpose.
 *
 * You may NOT use this Software unless you have an active Edge Impulse subscription
 * that meets the eligibility requirements for the applicable License, subject to
 * your full and continued compliance with the terms and conditions of the License,
 * including without limitation any usage restrictions under the applicable License.
 *
 * If you do not have an active Edge Impulse product plan subscription, or if use
 * of this Software exceeds the usage limitations of your Edge Impulse product plan
 * subscription, you are not permitted to use this Software and must immediately
 * delete and erase all copies of this Software within your control or possession.
 * Edge Impulse reserves all rights and remedies available to enforce its rights.
 *
 * Unless required by applicable law or agreed to in writing, the Software is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing
 * permissions, disclaimers and limitations under the License.
 */
#ifndef _EIDSP_RETURN_TYPES_H_
#define _EIDSP_RETURN_TYPES_H_

#include <stdint.h>

/**
 * @defgroup ei_returntypes Return codes
 *
 * Return codes for Edge Impulse functions.
 *
 * **Source**: [dsp/returntypes.h](https://github.com/edgeimpulse/inferencing-sdk-cpp/blob/master/dsp/returntypes.h)
 *
 * @addtogroup ei_returntypes
 * @{
 */

// outside of namespace for backwards compat
typedef enum {
    EI_IMPULSE_OK = 0, /**< Success */
    EI_IMPULSE_ERROR_SHAPES_DONT_MATCH = -1, /**< The shape of data does not match the shape of input layer. */
    EI_IMPULSE_CANCELED = -2, /**< Impulse execution is cancelled by user. */
    EI_IMPULSE_TFLITE_ERROR = -3, /**< Error in TesnorFlow Lite inference engine */
    EI_IMPULSE_DSP_ERROR = -5, /**< Error in processing portion of impulse */
    EI_IMPULSE_TFLITE_ARENA_ALLOC_FAILED = -6, /**< Failed to allocate memory in TensorFlow Lite arena, often caused by a lack of available heap memory. */
    EI_IMPULSE_CUBEAI_ERROR = -7, /**< Error in CubeAI inference engine (STM32) */
    EI_IMPULSE_ALLOC_FAILED = -8, /**< Memory allocation failed. Could be caused by a fragmented heap. Try to increase heap size. */
    EI_IMPULSE_ONLY_SUPPORTED_FOR_IMAGES = -9, /**< This function is only supported for impulses with an image input. */
    EI_IMPULSE_UNSUPPORTED_INFERENCING_ENGINE = -10, /**< The chosen inference engine (e.g. in Studio) is incapable of running this impulse. */
    EI_IMPULSE_OUT_OF_MEMORY = -11, /**< Out of memory. Could be caused by a fragmented heap. Try to increase heap size. */
    EI_IMPULSE_INPUT_TENSOR_WAS_NULL = -13, /**< Input tensor was null */
    EI_IMPULSE_OUTPUT_TENSOR_WAS_NULL = -14, /**< Output tensor was null */
    EI_IMPULSE_SCORE_TENSOR_WAS_NULL = -15, /**< Score tensor is null (for SSD Object Detection models). */
    EI_IMPULSE_LABEL_TENSOR_WAS_NULL = -16, /**< Label tensor is null (for SSD Object Detection models). */
    EI_IMPULSE_TENSORRT_INIT_FAILED = -17, /**< TensorRT (NVIDIA) initialization failed. */
    EI_IMPULSE_DRPAI_INIT_FAILED = -18, /**< DRP-AI (Renesas) initialization failed. */
    EI_IMPULSE_DRPAI_RUNTIME_FAILED = -19, /**< DRP-AI (Renesas) runtime failed. */
    EI_IMPULSE_DEPRECATED_MODEL = -20, /**< The model is deprecated and cannot be used. You should re-export the impulse from Studio. */
    EI_IMPULSE_LAST_LAYER_NOT_AVAILABLE = -21, /**< The last layer is not available in the model. */
    EI_IMPULSE_INFERENCE_ERROR = -22, /**< Error during inference. */
    EI_IMPULSE_AKIDA_ERROR = -23, /**< Error in Akida inference engine (BrainChip) */
    EI_IMPULSE_INVALID_SIZE = -24, /**<The shape of data does not match the shape of input layer. */
    EI_IMPULSE_ONNX_ERROR = -25, /**< Error in ONNX inference engine */
    EI_IMPULSE_MEMRYX_ERROR = -26, /**< Error in Memryx inference engine */
    EI_IMPULSE_DEVICE_INIT_ERROR = -27, /**< Device initialization (usually NPU accelerator) failed */
    EI_IMPULSE_LAST_LAYER_NOT_SUPPORTED = -28, /**< The last layer is not supported by inferencing engine. */
    EI_IMPULSE_POSTPROCESSING_ERROR = -29, /**< Error in post-processing portion of impulse */
    EI_IMPULSE_DATA_NORMALIZATION_ERROR = -30, /**< Error in data normalization portion of impulse */
    EI_IMPULSE_FREEFORM_OUTPUT_NULL = -31, /**< Error when result.freeform_output is null */
    EI_IMPULSE_FREEFORM_OUTPUT_SIZE_MISMATCH = -32, /**< Error when result.freeform_output is the wrong size */
    EI_IMPULSE_OUTPUT_TENSOR_NULL = -33, /**< Error when the output tensor cannot be found in result->_raw_outputs */
} EI_IMPULSE_ERROR;

#endif // _EIDSP_RETURN_TYPES_H_

/** @} */